#ifndef SOLDIER_MACROS_H
#define SOLDIER_MACROS_H

// MACROS FOR EASIER SOLDIER CONTROL
#include "teamturns.h"
#include "soldier profile.h"
#include "assignments.h"

// MACROS
#define RPC_RECRUITED( p )	( ( p->ubProfile == NO_PROFILE ) ? FALSE : ( gMercProfiles[ p->ubProfile ].ubMiscFlags & PROFILE_MISC_FLAG_RECRUITED ) )

#define AM_AN_EPC( p )	( ( p->ubProfile == NO_PROFILE ) ? FALSE : ( gMercProfiles[ p->ubProfile ].ubMiscFlags & PROFILE_MISC_FLAG_EPCACTIVE ) )

#define AM_A_ROBOT( p )	( ( p->ubProfile == NO_PROFILE ) ? FALSE : ( gMercProfiles[ p->ubProfile ].ubBodyType == ROBOTNOWEAPON ) )


#define OK_ENEMY_MERC( p ) ( !p->bNeutral && (p->bSide != gbPlayerNum ) && p->bLife >= OKLIFE )

// Checks if our guy can be controllable .... checks bInSector, team, on duty, etc...
#define OK_CONTROLLABLE_MERC( p ) ( p->bLife >= OKLIFE && p->bActive && p->bInSector && p->bTeam == gbPlayerNum && p->bAssignment < ON_DUTY  )

// Checks if our guy can be controllable .... checks bInSector, team, on duty, etc...
#define OK_INSECTOR_MERC( p ) ( p->bLife >= OKLIFE && p->bActive && p->bInSector && p->bTeam == gbPlayerNum && p->bAssignment < ON_DUTY )
		
// Checkf if our guy can be selected and is not in a position where our team has an interupt and he does not have one...
#define OK_INTERRUPT_MERC( p ) ( ( INTERRUPT_QUEUED != 0 ) ? ( ( p->bMoved ) ? FALSE : TRUE ) : TRUE )

#define CREATURE_OR_BLOODCAT( p ) ( (p->uiStatusFlags & SOLDIER_MONSTER) || p->ubBodyType == BLOODCAT )

#define TANK( p ) (p->ubBodyType == TANK_NE || p->ubBodyType == TANK_NW )
// marke strogg is strogg alien strogg or pure alien
#define STROGG( p ) (p->ubBodyType >= STROGG_INF && p->ubBodyType <= STROGG_MACHINEGUN_GUARD )
#define STROGGorALIEN( p ) (p->ubBodyType >= STROGG_INF && p->ubBodyType <= VICTIM_FEMALE )
#define ALIEN( p ) (p->ubBodyType >= ALIEN_EGG && p->ubBodyType <= VICTIM_FEMALE )
// end new makros
#define OK_ENTERABLE_VEHICLE( p )	( ( p->uiStatusFlags & SOLDIER_VEHICLE ) && !TANK( p ) && p->bLife >= OKLIFE  )

#endif